/* Combustion Analysis Tool (CAT)
   www.catool.org
   
   Filename: utils.h

   Purpose:  Provide common programming interface for processing acquired engine data
  
   Author:   Ben Brown
   Version:  1.2
   Date:     19.10.2015

   Revision: GPL Release

   Copyright (C) Xarin Limited, 2000-2024

      This program is free software: you can redistribute it and/or modify
      it under the terms of version 2 of the GNU General Public License as
      published by the Free Software Foundation.

      This program is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
      GNU General Public License for more details.

      You should have received a copy of the GNU General Public License
      along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __UTILS_H__
#define __UTILS_H__

#include <stdio.h>

enum {
    SILENT = 0,
    FATAL = 1,
    MSG_ERROR = 2,
    WARNING = 3,
    NOTICE = 4,
    DEBUG = 5,
};

enum {
    SEPARATOR_SPACE = 1,
    SEPARATOR_TAB = 2,
    SEPARATOR_COMMA = 4,
    SEPARATOR_ALL = 7,
    SEPARATOR_CUSTOM = 8,
};

long fsize(FILE* file_handle);
size_t fwrite_short(const short data, FILE* file_handle);
size_t fwrite_char(const char* data, const size_t length, FILE* file_handle);
size_t fwrite_double(const double data, FILE* file_handle);
size_t fwrite_float(const float data, FILE* file_handle);
size_t fwrite_int(const int data, FILE* file_handle);
size_t fwrite_uint(const unsigned int data, FILE* file_handle);
size_t fwrite_padded_char(const char* data, const size_t length, FILE* file_handle);
size_t fwrite_string(const char* string, FILE* file, const size_t maximum_count);
size_t fread_string(char* string, FILE* file, const size_t maximum_count);
size_t fwrite_null(const unsigned int count, FILE* file_handle);
void swap_endian_2(void* input);
void swap_endian_4(void* input);
void swap_endian_8(void* input);
time_t convert_time(char* string_time);
void create_time(const time_t* input_time, char* output_time);
int case_insensitive_compare(const char* input_string, const char* compare_string, const size_t max_length);
void set_bit(unsigned char* byte,const unsigned int bit);
void clear_bit(unsigned char* byte,const unsigned int bit);
int read_bit(const unsigned char* byte,const unsigned int bit);
void read_line(const char* in, char* out[], const unsigned int max_number_of_arguments, const unsigned int max_argument_size, unsigned int* arguments, const unsigned int separator, const char custom);
bool determine_range(const char* input, const size_t length, unsigned int* values, unsigned int number_of_values);
void logmessage(const unsigned int level, const char* format, ... );

#endif
