/* catoolRT
   www.xarin.com
   
   Filename: maths.h

   Purpose:  Realtime combustion data acquisition and analysis
  
   Author:   Ben Brown
   Version:  11.2 beta
   Date:     16.03.17

   Copyright (C) Xarin Limited, 2000-2024
   All Rights Reserved.
*/

#ifndef _MATHS_H_
#define _MATHS_H_

enum {
	SORT_AXIS_NONE = 0,
	SORT_AXIS_ASCENDING = 1,
	SORT_AXIS_DECENDING = 2,
};

typedef struct {
	unsigned int x_breakpoints;
	float* x;
	float* y;
} Table2D;

typedef struct {
	unsigned int x_breakpoints;
	unsigned int y_breakpoints;
	float* x;
	float* y;
	float* z;
} Table3D;

void radix_sort_indices_split_array(const float* array, unsigned int* index, size_t array_size, size_t start, size_t count, const unsigned char sort_type);
void radix_sort_indices(const float* array, unsigned int* index, size_t count, const unsigned char sort_type);
void radix_sort(float* array, size_t count);
float median_sort(float* data, const size_t count);
void minmaxf(const float* array, const size_t array_size, float* minimum, float* maximum);
void minmax(const double* array, const size_t array_size, double* minimum, double* maximum, const size_t offset, const size_t skip);
float minf(const float* array, const size_t array_size);
float maxf(const float* array, const size_t array_size);
float sumf(const float* array, const size_t array_size);
float lookup_2d(const float* x_axis, const float* y_axis, const unsigned int data_points, const float x);
float lookup_2dT(Table2D* table, const float x);
float lookup_3d(const float* x_axis, const float* y_axis, const float* z_axis, const unsigned int x_data_points, const unsigned int y_data_points, const float x, const float y);
float lookup_3dT(Table3D* table, const float x, const float y);
float calculate_mean(const float* data, const unsigned int number_of_samples);
int calculate_first_order_least_squares(const unsigned int number_of_data_points, const float* x_array_data, const float* y_array_data, float* a0, float* a1);
int calculate_second_order_least_squares(const unsigned int number_of_data_points, const float* x_array_data, const float* y_array_data, float* a0, float* a1, float* a2);
float calculate_coefficient_of_determination(const unsigned int number_of_data_points, const float* data, const float* model);
void calc_sg_coefficients(const unsigned int order, float* coefficients);

#endif