/* Combustion Analysis Tool (CAT)
   www.catool.org
   
   Filename: matfile.h

   Purpose:  Provide common programming interface for processing acquired engine data
  
   Author:   Ben Brown
   Version:  1.2
   Date:     19.10.2015

   Revision: GPL Release

   Copyright (C) Xarin Limited, 2000-2024

      This program is free software: you can redistribute it and/or modify
      it under the terms of version 2 of the GNU General Public License as
      published by the Free Software Foundation.

      This program is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
      GNU General Public License for more details.

      You should have received a copy of the GNU General Public License
      along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __MATFILE_H__
#define __MATFILE_H__

#include <stdio.h>

enum {
    miINT8 = 1,
    miUINT8 = 2,
    miINT16 = 3,
    miUINT16 = 4,
    miINT32 = 5,
    miUINT32 = 6,
    miSINGLE = 7,
    miDOUBLE = 9,
    miINT64 = 12,
    miUINT64 = 13,
    miMATRIX = 14,
    miCOMPRESSED = 15,
    miUTF8 = 16,
    miUTF16 = 17,
    miUTF32 = 18,
};

enum {
    mxCELL_CLASS = 1,
    mxSTRUCT_CLASS = 2,
    mxOBJECT_CLASS = 3,
    mxCHAR_CLASS = 4,
    mxSPARSE_CLASS = 5,
    mxDOUBLE_CLASS = 6,
    mxSINGLE_CLASS = 7,
    mxINT8_CLASS = 8,
    mxUINT8_CLASS = 9,
    mxINT16_CLASS = 10,
    mxUINT16_CLASS = 11,
    mxINT32_CLASS = 12,
    mxUINT32_CLASS = 13,
    mxINT64_CLASS = 14,
    mxUINT64_CLASS = 15,
};

#define mfNONE          0x0000
#define mfLOGICAL       0x0200
#define mfGLOBAL        0x0400
#define mfCOMPLEX       0x0800

unsigned int sizeof_datatype(const unsigned int datatype);
size_t ascii_to_utf16(const char* ascii_in, char** utf16_out, const size_t maximum_length);
void validate_variable_name(char* var_name);
void matlab_file_open(FILE* file_handle);
void matlab_file_close(FILE* file_handle);
void matlab_file_write(FILE* file_handle, const unsigned int data_type, const void* data, const unsigned int data_size);
void matlab_file_write_numeric_array(FILE* file_handle, const unsigned int data_type, const bool global, const bool logical, const char* array_name, const unsigned int number_of_array_dimensions, const int* dimensions_data, const void* real_data, const void* imaginary_data);
void matlab_file_write_channel(FILE* file_handle, const FileData* file, const unsigned int number_of_cycles, ChannelData* channel_data);
void generate_matlab_channelnames(FileData* file,Analysis* analysis);
void matlab_file_write_double_numeric_array(FILE* file_handle,const double value);
void matlab_file_write_uint8_numeric_array(FILE* file_handle,const unsigned int value);
void matlab_file_write_string_numeric_array(FILE* file_handle,const char* string,int max_length);
#ifdef _CATOOL_UNICODE_
void matlab_file_write_wchar_numeric_array(FILE* file_handle, const wchar_t* string, int max_length);
bool save_matlab_file(FileData* file, const wchar_t* filename, Analysis* analysis, const unsigned int ifile_output);
#else
bool save_matlab_file(FileData* file, const char* filename, Analysis* analysis, const unsigned int ifile_output);
#endif
#endif
