/* Combustion Analysis Tool (CAT)
   www.catool.org

   Filename: ifile.h

   Purpose:  Provide common programming interface for processing acquired engine data

   Author:   Ben Brown
   Version:  1.2
   Date:     19.10.2015

   Revision: GPL Release

   Copyright (C) Xarin Limited, 2000-2024

      This program is free software: you can redistribute it and/or modify
      it under the terms of version 2 of the GNU General Public License as
      published by the Free Software Foundation.

      This program is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
      GNU General Public License for more details.

      You should have received a copy of the GNU General Public License
      along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __IFILE_H__
#define __IFILE_H__

#ifdef _CATOOL_UNICODE_
bool load_ifile_header(FileData* file, const wchar_t* filename, const unsigned int grpflg);
bool save_ifile(FileData* file, const wchar_t* filename, Analysis* analysis, const unsigned int grpflg, const unsigned int grpflg_float);
bool is_valid_ifile(const wchar_t* filename);
#else
bool load_ifile_header(FileData* file, const char* filename, const unsigned int grpflg);
bool save_ifile(FileData* file, const char* filename, Analysis* analysis, const unsigned int grpflg, const unsigned int grpflg_float);
bool is_valid_ifile(const char* filename);
#endif
bool load_ifile_channel(FileData* file, const unsigned int channel);
void create_time(const time_t* input_time, char* output_time);

#endif
