/* Combustion Analysis Tool (CAT)
   www.catool.org
   
   Filename: filter.h

   Purpose:  Provide common programming interface for processing acquired engine data
  
   Author:   Ben Brown
   Version:  1.2
   Date:     19.10.2015

   Revision: GPL Release

   Copyright (C) Xarin Limited, 2000-2024

      This program is free software: you can redistribute it and/or modify
      it under the terms of version 2 of the GNU General Public License as
      published by the Free Software Foundation.

      This program is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
      GNU General Public License for more details.

      You should have received a copy of the GNU General Public License
      along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __FILTER_H__
#define __FILTER_H__

typedef struct {
	float* data;
	unsigned int data_size;
	float* c;
	unsigned int c_size;
	float* h;
	unsigned int h_size;
	float* f;
	unsigned int f_size;
    unsigned int order;
    float size;
    unsigned int type;
    unsigned int number_of_samples;
} Filter;

bool filter_calculate(const unsigned int number_of_samples, const unsigned int filter_type, const float sampled_frequency, const unsigned int window_type, float lower_frequency, float upper_frequency, Filter* filter);
bool filter_data(float* data, Filter* filter);
bool filter_channel(FileData* file, const unsigned int channel, const float default_engine_speed);
bool calculate_window(float* coefficient, const unsigned int N, const unsigned int window_type);
bool prepare_filter(Filter* filter);
bool finish_filter(Filter* filter);

#endif
