/* Combustion Analysis Tool (CAT)
   www.catool.org
   
   Filename: dat670.h

   Purpose:  Provide common programming interface for processing acquired engine data
  
   Author:   Ben Brown
   Version:  1.2
   Date:     19.10.2015

   Revision: GPL Release

   Copyright (C) Xarin Limited, 2000-2024

      This program is free software: you can redistribute it and/or modify
      it under the terms of version 2 of the GNU General Public License as
      published by the Free Software Foundation.

      This program is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
      GNU General Public License for more details.

      You should have received a copy of the GNU General Public License
      along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __DAT670_H__
#define __DAT670_H__

#ifdef _MSC_VER
#if (_MSC_VER < 1300)
   typedef signed char       int8_t;
   typedef signed short      int16_t;
   typedef signed int        int32_t;
   typedef unsigned char     uint8_t;
   typedef unsigned short    uint16_t;
   typedef unsigned int      uint32_t;
#else
   typedef signed __int8     int8_t;
   typedef signed __int16    int16_t;
   typedef signed __int32    int32_t;
   typedef unsigned __int8   uint8_t;
   typedef unsigned __int16  uint16_t;
   typedef unsigned __int32  uint32_t;
#endif
typedef signed __int64       int64_t;
typedef unsigned __int64     uint64_t;
#else
#include <stdint.h>
#endif

typedef float ieee32_t;
typedef double ieee64_t;

typedef struct 
{
	uint8_t name[10];
	uint8_t einh[10];
	ieee64_t wert;
} BPAR;

typedef struct 
{
	int16_t parlng;
	int16_t grpanz;
	uint8_t filkom[80];
	uint8_t mesdat[24];
	uint8_t parfil[18];
	uint8_t pronam[18];
	uint8_t prfstd[10];
	uint8_t motnam[18];
	int16_t mottyp;
	int16_t tktanz;
	int16_t geoein;
	ieee64_t hublng;
	ieee64_t pleuel;
	ieee64_t bohrng;
	ieee64_t kompre;
	ieee64_t desaxi;
	int32_t grpflg;
	int32_t datahandle;
	int16_t version;
	ieee64_t desaxi2;
	uint32_t pExtensions;
	BPAR bpar[28];
} PARBLK;

typedef struct 
{
	uint8_t signam[10];
	uint8_t sigein[10];
	uint8_t sigkom[6];
	ieee32_t minimum;
	ieee32_t maximum;
	ieee64_t dstov;
	ieee64_t kstov;
	int32_t abskor;
	int16_t desori;
	int32_t zykofs;
	int16_t kaltyp;
	int16_t nultyp;
	int16_t sigtyp;
	int16_t bitnum;
	int32_t mitofs;
	ieee64_t nulwrt;
	ieee64_t kalfak[2];
	int32_t intern[6];
	ieee64_t refwrt;
} DATDIR;

typedef struct 
{
	int32_t beranf;
	int32_t wrtanz;
	int32_t absint;
	int32_t beradr;
	int32_t adrint;
} MPTAB;

typedef struct 
{
	int16_t datart;
	int16_t absart;
	uint8_t absein[10];
	ieee64_t dltphi;
	ieee64_t dltzei;
	int16_t kananz;
	int32_t absanf;
	int32_t absend;
	int16_t fortyp;
	int16_t beranz;
	int16_t blkanz;
	int32_t zykanz;
	int32_t zykanf;
	int32_t zykend;
	int32_t zyklng;
	int32_t zyksta;
	int32_t zyksum;
	int16_t datfor;
	int16_t mitanz;
	int16_t mitkor;
	int16_t datofs;
	DATDIR *diradr;
	uint8_t *absadr;
	MPTAB *mpladr;
	int32_t *aztadr;
	int16_t *rztadr;
	uint8_t *datadr;
	int32_t refanf;
	ieee64_t thekx1;
	ieee64_t thekx2;
	ieee64_t polexp;
	ieee64_t thefac;
	uint8_t refzyl[10];
	uint8_t refsau[10];
	uint8_t refaus[10];
	int32_t aztlen;
	int32_t memhandle;
	int32_t abslen;
	int16_t refzylmit;
	int16_t refsaumit;
	int16_t refausmit;
	int16_t azttyp;
	int32_t aztofs;
	int32_t blkofs;
	int32_t blkdur;
	int32_t blknum;
	uint8_t *synadr;
	int32_t synlen;
	uint8_t reserve[44];
} DATGRP;

typedef struct
{
	uint32_t lNumberOfObjects;
	uint32_t lFirstExtensionObjectFilePos;		/* was int32_t */
	uint32_t lLastExtensionObjectFilePos;		/* was int32_t */
} S_IfileExtension;

typedef struct
{
	int32_t eType;
	uint32_t ulKeyLength;
	uint32_t lKeyFilePos;						/* was int32_t */
	uint32_t ulObjectSize;
	uint32_t lObjectFilePos;					/* was int32_t */
	uint32_t lNextExtensionObjectFilePos;		/* was int32_t */
} S_ExtensionObject;

typedef struct
{
	uint32_t ulNameLength;
	uint8_t* pcName;
	int32_t ulUnitLength;
	uint8_t* pcUnit;
	ieee64_t dValue;
} S_ParameterStructure;

typedef struct
{
	uint32_t ulNameLength;
	uint8_t* pcName;
} S_ExtendedSignalName;

#endif
