/* Combustion Analysis Tool (CAT)
   www.catool.org

   Filename: csvfile.h

   Purpose:  Provide common programming interface for processing acquired engine data

   Author:   Ben Brown
   Version:  1.2
   Date:     19.10.2015

   Revision: GPL Release

   Copyright (C) Xarin Limited, 2000-2024

      This program is free software: you can redistribute it and/or modify
      it under the terms of version 2 of the GNU General Public License as
      published by the Free Software Foundation.

      This program is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
      GNU General Public License for more details.

      You should have received a copy of the GNU General Public License
      along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __CSVFILE_H__
#define __CSVFILE_H__

bool save_csv_file(
	const FileData* file,
#ifdef _CATOOL_UNICODE_
	const wchar_t* filename,
#else
	const char* filename,
#endif
	const Analysis* analysis,
	const unsigned int output_data);
bool load_csv_file_header(
	FileData* file,
#ifdef _CATOOL_UNICODE_
	const wchar_t* filename,
#else
	const char* filename,
#endif
	AbscissaData* abscissa,
	unsigned int* resolution,
	const unsigned int abscissa_type,
	float* recording_length,
	unsigned int* number_of_lines_to_skip,
	const bool* skip_columns);
unsigned int load_csv_file(
	FileData* file,
	const unsigned int resolution,
	const unsigned int number_of_lines_to_skip,
	const unsigned int channel_names_line,
	const unsigned int channel_units_line,
	const bool* skip_columns,
	const unsigned int start_cycle,
	const unsigned int data_type,
	const bool align_tdc);

#endif
