/* Combustion Analysis Tool (CAT)
   www.catool.org
  
   Filename: atimat.h
  
   Purpose:  Provide common programming interface for processing acquired engine data
  
   Author:   Ben Brown
   Version:  1.2
   Date:     20.06.13

   Revision: GPL Release

   Copyright (C) Xarin Limited, 2000-2024

      This program is free software: you can redistribute it and/or modify
      it under the terms of version 2 of the GNU General Public License as
      published by the Free Software Foundation.

      This program is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
      GNU General Public License for more details.

      You should have received a copy of the GNU General Public License
      along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _ATIMAT_H_
#define _ATIMAT_H_

#include <stdio.h>

#ifdef _CATOOL_UNICODE_
bool save_atimat_file(FileData* file, wchar_t* filename, Analysis* analysis, const unsigned int ifile_output);
#else
bool save_atimat_file(FileData* file, char* filename, Analysis* analysis, const unsigned int ifile_output);
#endif

#endif
