/* Combustion Analysis Tool (CAT)
   www.catool.org

   Filename: abscissa.h

   Purpose:  Provide common programming interface for processing acquired engine data

   Author:   Ben Brown
   Version:  1.2
   Date:     19.10.2015

   Revision: GPL Release

   Copyright (C) Xarin Limited, 2000-2024

      This program is free software: you can redistribute it and/or modify
      it under the terms of version 2 of the GNU General Public License as
      published by the Free Software Foundation.

      This program is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
      GNU General Public License for more details.

      You should have received a copy of the GNU General Public License
      along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __ABSCISSA_H__
#define __ABSCISSA_H__

#include "cat.h"

unsigned int Copy_Abscissa(AbscissaData* source, AbscissaData* dest);
void Empty_Abscissa(AbscissaData* abscissa);
void Zero_Abscissa(AbscissaData* absicssa);
bool Calculate_Abscissa_Lookups(AbscissaData* abscissa, const unsigned int pulses_per_cycle, const unsigned int number_of_strokes, const float minimum_resolution);
bool Build_Abscissa(const FileData* file, const AbscissaBlocks* channel_blocks, AbscissaData* abscissa);
void Add_Abscissa(AbscissaData* abscissa, const unsigned int number_of_strokes, const unsigned int min_res_ppr, const unsigned int mt, const float start_angle, const float finish_angle, const float resolution);
unsigned int Abscissa_Samples(const AbscissaData* abscissa);
void GetAxis(const AbscissaData* abscissa, const unsigned int variable_type, void* axis, const size_t axis_size);

#endif
